/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.data.repo;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.invoice.domain.AInvoiceType;
import com.android.invoice.domain.use_case.invoice.post.CheckInvoiceErrors;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceProcess;
import com.android.order.domain.model.AOrderDto;
import com.android.order.domain.use_case.InsertAOrder;
import com.android.order.domain.use_case.read.MakeOrderQuery;
import com.android.order.domain.use_case.read.QueryOrders;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class AOrderRepository
extends AndroidRepository<AOrderDto> {
    @Resource
    @Lazy
    private QueryOrders queryOrders;
    @Resource
    @Lazy
    private MakeOrderQuery makeOrderQuery;
    @Resource
    @Lazy
    private CheckInvoiceErrors checkInvoiceErrors;
    @Resource
    @Lazy
    private InsertAOrder insertAOrder;
    @Resource
    @Lazy
    private InsertAInvoiceProcess insertAInvoiceProcess;

    public AOrderRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<AOrderDto> customQueryAsObject(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        if (sql == null) {
            return null;
        }
        List result = this.queryOrders.invoke(sql, login);
        return new BaseResponse.Builder().data(result).totalCount(this.getTotalCount()).totalPages(this.getTotalPages()).build();
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(RequestData request, SettingLoader settingsLoader) {
        return this.makeOrderQuery.invoke(request, settingsLoader.getLogin());
    }

    protected BaseResponse<GenericResponse> insert(AOrderDto order, LoginDto login, TransactionStatus status) throws TncException {
        BaseResponse.Builder response = new BaseResponse.Builder();
        order.setClientId(order.getId());
        order.setAOrderTypeName(AInvoiceType.find((Integer)order.getOrderType()));
        if (ConvertStr.nullSafeLong((Long)order.getServerId()) > 0L) {
            this.deleteFormerOrders(String.valueOf(order.getServerId()), order.getAOrderTypeName());
        }
        try {
            this.checkInvoiceErrors.invoke(order);
            this.insertAOrder.invoke(order);
            this.insertAInvoiceProcess.invoke(order);
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            return response.withError(this.buildError(order, t)).build();
        }
        return response.data((Object)this.makeSuccessMap(order)).build();
    }

    private void deleteFormerOrders(String serverId, AInvoiceType type) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        jdbc.update(" DELETE FROM RqTitle WHERE RqIndex = ?", new Object[]{serverId});
        jdbc.update(" DELETE FROM RqDetail WHERE RqIndex = ? AND RqType = ?", new Object[]{serverId, type.getTypeChar()});
        jdbc.update(" DELETE FROM ItemFact WHERE FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{serverId, type.getInvoiceTypeForVariety()});
        jdbc.update(" DELETE FROM SaveClsF WHERE FAC_CODE = ? AND FAC_TYPE = 'M'", new Object[]{serverId});
    }

    private BaseError buildError(@NotNull AOrderDto order, Throwable mainException) {
        TncException e = TncException.fromException((Throwable)mainException);
        if (order.getId() > 0L) {
            e.putMoreInfo("id", (Object)order.getCode());
        }
        e.putMoreInfo("errorDetail", (Object)("MESSAGE = " + mainException.getMessage() + " CAUSE = " + mainException.getCause()));
        return e.makeAndroidError();
    }

    @NotNull
    private GenericResponse makeSuccessMap(@NotNull AOrderDto order) {
        return GenericResponse.builder().id(order.getCode()).generatedCode(ConvertStr.nullSafeLong((Long)order.getId()).toString()).requestIdentifier(ConvertStr.nullSafeLong((Long)order.getClientId()).toString()).clientId(order.getClientId().longValue()).code(order.getCode()).build();
    }

    public BaseResponse<GenericResponse> delete(String serverId, int type) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        try {
            this.deleteFormerOrders(serverId, AInvoiceType.find((Integer)type));
            return response.data((Object)GenericResponse.builder().message("deleted successfully").code("200").build()).build();
        }
        catch (TncException e) {
            return response.withError(e.makeAndroidError()).build();
        }
    }
}

